% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.r
\name{getDictionary}
\alias{getDictionary}
\title{Create an empty dictionary from the flags in a document template}
\usage{
getDictionary(filename)
}
\arguments{
\item{filename}{The file path to the document template. Supports .doc and .docx}
}
\value{
A two-column data frame intended for populating data into the template:
\itemize{
\item \strong{flag}: Lists all the flags identified in the document.
\item \strong{replace values}: An empty column where users can insert values to replace the corresponding flags in the template.
}
}
\description{
Scans the input file for strings enclosed by flag wings: « »
}
\examples{

# Path to the sample template file included in the package
template_path <- system.file("template_document", "Template.docx", package="docket")

# Create a dictionary by using the getDictionary function on the sample template file
result <- getDictionary(template_path)
print(result)

}
