% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchDocket.r
\name{batchDocket}
\alias{batchDocket}
\title{Create Documents}
\usage{
batchDocket(filename, batchDictionary)
}
\arguments{
\item{filename}{The file path to the document template. Supports .doc and .docx formats}

\item{batchDictionary}{A data frame where each row represents a flag to be replaced in the template document
and each column represents a final document to be generated}
}
\value{
Generates new .doc or .docx files with the flags replaced by the specified data for that column
}
\description{
Scans the input template file for specified flags as defined in the dictionary,
and replaces them with corresponding data. Repeats the process for each column, generating a new document
for each column which is saved as the file name and path listed in row 1
}
\examples{
# Path to the sample template file included in the package
template_path <- system.file("batch_document", "batchTemplate.docx", package="docket")
output_paths <- as.list(paste0(dirname(template_path), paste0("/batch document", 1:5, ".docx")))

# Create a dictionary by using the getDictionary function on the sample template file
result <- getBatchDictionary(template_path, output_paths)
result[2,2:ncol(result)] <- Sys.getenv("USERNAME") #Author name
result[3,2:ncol(result)] <- as.character(Sys.Date())
result[4,2:ncol(result)] <- 123
result[5,2:ncol(result)] <- 456
result[6,2:ncol(result)] <- 789
result[7,2:ncol(result)] <- sum(as.numeric(result[4:6,2]))

# Verify that the result dictionary is valid
if (checkBatchDictionary(result) == TRUE) {
 batchDocket(template_path, result)
 for (i in 1:length(output_paths)) {
   if (file.exists(output_paths[[i]])) {
     print(paste("docket", i, "Successfully Created"))
   }
 }
}
}
