% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docs.R
\name{doctest-tag}
\alias{doctest-tag}
\alias{@doctest}
\title{Start a doctest}
\description{
\verb{@doctest} starts a doctest: a code example that also contains one or more
\link[testthat:testthat-package]{testthat} expectations.
}
\details{
Use \verb{@doctest} where you would usually use \verb{@examples}. Then add
\link{@expect} and \link{@expectRaw} tags beneath it to create expectations.

By default, a test labelled "Example: <object name>" is created. You
can put a different label after \verb{@doctest}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{#' @doctest Positive numbers
#'
#' x <- 1
#' @expect equal(x)
#' abs(x)
#'
#' @doctest Negative numbers
#' x <- -1
#' @expect equal(-x)
#' abs(x)
}\if{html}{\out{</div>}}

You can have more than one \verb{@doctest} tag in a roxygen block. Each doctest
will create a new test, but they will all be merged into a single Rd example.
Each doctest must contain an independent unit of code. For example, this
won't work:

\if{html}{\out{<div class="sourceCode">}}\preformatted{#' @doctest Test x
#' @expect equal(2)
#' x <- 1 + 1
#'
#' @doctest Keep testing x
#' @expect equal(4)
#' x^2
#' # Test will error, because `x` has not been defined here
}\if{html}{\out{</div>}}

A test will only be written if the \verb{@doctest} section has at least one
\link{@expect} or \link{@expectRaw} in it. This lets you change \verb{@examples} to
\verb{@doctest} in your code, without generating unexpected tests.
}
