% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph-conversion.R
\name{dodgr_to_sf}
\alias{dodgr_to_sf}
\title{dodgr_to_sf}
\usage{
dodgr_to_sf(net)
}
\arguments{
\item{net}{A \pkg{dodgr} network}
}
\value{
Equivalent object of class \pkg{sf}.
}
\description{
Convert a \code{dodgr} graph into an equivalent \pkg{sf} object.  Works by
aggregating edges into \code{LINESTRING} objects representing longest sequences
between all junction nodes. The resultant objects will generally contain more
\code{LINESTRING} objects than the original \pkg{sf} object, because the former
will be bisected at every junction point.
}
\note{
Requires the \pkg{sf} package to be installed.
}
\examples{
hw <- weight_streetnet (hampi)
nrow(hw) # 5,729 edges
xy <- dodgr_to_sf (hw)
dim (xy) # 764 edges; 14 attributes
}
