% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iso.R
\name{dodgr_isochrones}
\alias{dodgr_isochrones}
\title{dodgr_isochrones}
\usage{
dodgr_isochrones(graph, from = NULL, tlim = NULL, heap = "BHeap")
}
\arguments{
\item{graph}{\code{data.frame} or equivalent object representing the network
graph (see Notes)}

\item{from}{Vector or matrix of points \strong{from} which isochrones are to
be calculated.}

\item{tlim}{Vector of desired limits of isochrones in seconds}

\item{heap}{Type of heap to use in priority queue. Options include
Fibonacci Heap (default; \code{FHeap}), Binary Heap (\code{BHeap}),
Trinomial Heap (\code{TriHeap}), Extended Trinomial Heap
(\code{TriHeapExt}, and 2-3 Heap (\code{Heap23}).}
}
\value{
A single \code{data.frame} of isochrones as points sorted anticlockwise
around each origin (\code{from}) point, with columns denoting the \code{from} points
and \code{tlim} value(s). The isochrones are given as \code{id} values and associated
coordinates of the series of points from each \code{from} point at the specified
isochrone times.

Isochrones are calculated by default using parallel computation with the
maximal number of available cores or threads. This number can be reduced by
specifying a value via \verb{RcppParallel::setThreadOptions (numThreads = <desired_number>)}.
}
\description{
Calculate isochrone contours from specified points. Function is fully
vectorized to calculate accept vectors of central points and vectors
defining multiple isochrone thresholds.
}
\examples{
\dontrun{
# Use osmdata package to extract 'SC'-format data:
library (osmdata)
dat <- opq ("hampi india") \%>\%
    add_osm_feature (key = "highway") \%>\%
    osmdata_sc ()
graph <- weight_streetnet (dat)
from <- sample (graph$.vx0, size = 100)
tlim <- c (5, 10, 20, 30, 60) * 60 # times in seconds
x <- dodgr_isochrones (graph, from = from, tlim)
}
}
