% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weight-railway.R
\name{weight_railway}
\alias{weight_railway}
\title{Weight a network for routing along railways.}
\usage{
weight_railway(
  x,
  type_col = "railway",
  id_col = "osm_id",
  keep_cols = c("maxspeed"),
  excluded = c("abandoned", "disused", "proposed", "razed")
)
}
\arguments{
\item{x}{A street network represented either as \code{sf} \code{LINESTRING}
objects, typically extracted with \link{dodgr_streetnet}.}

\item{type_col}{Specify column of the \code{sf} \code{data.frame} object
which designates different types of railways to be used for weighting
(default works with \code{osmdata} objects).}

\item{id_col}{Specify column of the \pkg{sf} \code{data.frame} object which
provides unique identifiers for each railway (default works with
\code{osmdata} objects).}

\item{keep_cols}{Vectors of columns from \code{sf_lines} to be kept in the
resultant \code{dodgr} network; vector can be either names or indices of
desired columns.}

\item{excluded}{Types of railways to exclude from routing.}
}
\value{
A \code{data.frame} of edges representing the rail network, along
with a column of graph component numbers.
}
\description{
Weight (or re-weight) an \code{sf}-formatted OSM street network for routing
along railways.
}
\note{
Default railway weighting is by distance. Other weighting schemes, such
as by maximum speed, can be implemented simply by modifying the
\code{d_weighted} column returned by this function accordingly.
}
\examples{
\dontrun{
# sample railway extraction with the 'osmdata' package
library (osmdata)
dat <- opq ("shinjuku") \%>\%
    add_osm_feature (key = "railway") \%>\%
    osmdata_sf (quiet = FALSE)
graph <- weight_railway (dat$osm_lines)
}
}
\seealso{
Other extraction: 
\code{\link{dodgr_streetnet}()},
\code{\link{dodgr_streetnet_sc}()},
\code{\link{weight_streetnet}()}
}
\concept{extraction}
