% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_doorprob.R
\name{calc_doorprob}
\alias{calc_doorprob}
\title{Calculate DOOR probability}
\usage{
calc_doorprob(
  y1 = NULL,
  y2 = NULL,
  data_type = c("freq", "prop"),
  summary_obj = NULL
)
}
\arguments{
\item{y1}{A vector of proportion or frequency distribution for group 1}

\item{y2}{A vector of proportion or frequency distribution for group 2}

\item{data_type}{Either "freq" for frequency input or "prop" for proportion input
when using y1 and y2}

\item{summary_obj}{A object returned by \code{door_summary()}; Alternative
input for y1 and y2}
}
\value{
DOOR probability
}
\description{
For summary level data, \code{y1} and \code{y2} should be given. For individual level data,
a \code{summary_obj} should be given.
}
\examples{
y1 = c(60, 30, 10)
y2 = c(50, 40, 10)
calc_doorprob(y1, y2)

## DOOR probability
##            0.545

p1 = c(.6, .3, .1)
p2 = c(.5, .4, .1)
calc_doorprob(p1, p2, data_type = "prop")

## DOOR probability
##            0.545

}
\seealso{
\code{\link[=door_summary]{door_summary()}}
}
