% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dosearch.R
\name{print.summary.dosearch}
\alias{print.summary.dosearch}
\title{Print the Summary of a \code{dosearch} Object}
\usage{
\method{print}{summary.dosearch}(x, max_chars = 300L, ...)
}
\arguments{
\item{x}{An object of class \code{summary.dosearch}.}

\item{max_chars}{Maximum number of characters of the formula to display. The
default is 300.}

\item{...}{Not used.}
}
\value{
\code{x} (invisibly)
}
\description{
Print the Summary of a \code{dosearch} Object
}
\examples{
data <- "p(x,y,z)"
query <- "p(y|do(x))"
graph <- "
  x -> y
  Z -> x
  z -> y
"
x <- dosearch(data, query, graph)
y <- summary(x)
print(y)

}
