% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Germlines.R
\name{createGermlines}
\alias{createGermlines}
\title{\link{createGermlines} Determine consensus clone sequence and create germline for clone}
\usage{
createGermlines(
  data,
  references,
  organism = "human",
  locus = "IGH",
  nproc = 1,
  seq = "sequence_alignment",
  v_call = "v_call",
  d_call = "d_call",
  j_call = "j_call",
  amino_acid = FALSE,
  id = "sequence_id",
  clone = "clone_id",
  v_germ_start = "v_germline_start",
  v_germ_end = "v_germline_end",
  v_germ_length = "v_germline_length",
  d_germ_start = "d_germline_start",
  d_germ_end = "d_germline_end",
  d_germ_length = "d_germline_length",
  j_germ_start = "j_germline_start",
  j_germ_end = "j_germline_end",
  j_germ_length = "j_germline_length",
  np1_length = "np1_length",
  np2_length = "np2_length",
  na.rm = TRUE,
  ...
)
}
\arguments{
\item{data}{AIRR-table containing sequences from one clone}

\item{references}{Full list of reference segments, see \link{readIMGT}}

\item{organism}{Species in \code{references} being analyzed}

\item{locus}{locus in \code{references} being analyzed}

\item{nproc}{Number of cores to use}

\item{seq}{Column name for sequence alignment}

\item{v_call}{Column name for V gene segment gene call}

\item{d_call}{Column name for D gene segment gene call}

\item{j_call}{Column name for J gene segment gene call}

\item{amino_acid}{Perform reconstruction on amino acid sequence (experimental)}

\item{id}{Column name for sequence ID}

\item{clone}{Column name for clone ID}

\item{v_germ_start}{Column name of index of V segment start within germline}

\item{v_germ_end}{Column name of index of V segment end within germline}

\item{v_germ_length}{Column name of index of V segment length within germline}

\item{d_germ_start}{Column name of index of D segment start within germline}

\item{d_germ_end}{Column name of index of D segment end within germline}

\item{d_germ_length}{Column name of index of D segment length within germline}

\item{j_germ_start}{Column name of index of J segment start within germline}

\item{j_germ_end}{Column name of index of J segment end within germline}

\item{j_germ_length}{Column name of index of J segment length within germline}

\item{np1_length}{Column name in receptor specifying np1 segment length}

\item{np2_length}{Column name in receptor specifying np2 segment length}

\item{na.rm}{Remove clones with failed germline reconstruction?}

\item{...}{Additional arguments passed to \link{buildGermline}}
}
\value{
Tibble with reconstructed germlines
}
\description{
\link{createGermlines} Determine consensus clone sequence and create germline for clone
}
\details{
Return object adds/edits following columns:
\itemize{
  \item  \code{seq}:  Sequences potentially padded  same length as germline
  \item  \code{germline_alignment}: Full length germline
  \item  \code{germline_alignment_d_mask}: Full length, D region masked
  \item  \code{vonly}:   V gene segment of germline if vonly=TRUE
  \item  \code{regions}: String of VDJ segment in position if use_regions=TRUE
}
}
\examples{
vdj_dir <- system.file("extdata", "germlines", "imgt", "human", "vdj", package="dowser")
imgt <- readIMGT(vdj_dir)
db <- createGermlines(ExampleAirr[1,], imgt)
}
\seealso{
\link{createGermlines} \link{buildGermline}, \link{stitchVDJ}
}
