% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Germlines.R
\name{buildGermline}
\alias{buildGermline}
\title{\code{buildGermline} reconstruct germline segments from alignment data}
\usage{
buildGermline(
  receptor,
  references,
  seq = "sequence_alignment",
  id = "sequence_id",
  clone = "clone_id",
  v_call = "v_call",
  d_call = "d_call",
  j_call = "j_call",
  v_germ_start = "v_germline_start",
  v_germ_end = "v_germline_end",
  v_germ_length = "v_germline_length",
  d_germ_start = "d_germline_start",
  d_germ_end = "d_germline_end",
  d_germ_length = "d_germline_length",
  j_germ_start = "j_germline_start",
  j_germ_end = "j_germline_end",
  j_germ_length = "j_germline_length",
  np1_length = "np1_length",
  np2_length = "np2_length",
  amino_acid = FALSE
)
}
\arguments{
\item{receptor}{row from AIRR-table containing sequence of interest}

\item{references}{list of reference segments. Must be specific to locus}

\item{seq}{Column name for sequence alignment}

\item{id}{Column name for sequence ID}

\item{clone}{Column name for clone ID}

\item{v_call}{Column name for V gene segment gene call}

\item{d_call}{Column name for D gene segment gene call}

\item{j_call}{Column name for J gene segment gene call}

\item{v_germ_start}{Column name of index of V segment start within germline}

\item{v_germ_end}{Column name of index of V segment end within germline}

\item{v_germ_length}{Column name of index of V segment length within germline}

\item{d_germ_start}{Column name of index of D segment start within germline}

\item{d_germ_end}{Column name of index of D segment end within germline}

\item{d_germ_length}{Column name of index of D segment length within germline}

\item{j_germ_start}{Column name of index of J segment start within germline}

\item{j_germ_end}{Column name of index of J segment end within germline}

\item{j_germ_length}{Column name of index of J segment length within germline}

\item{np1_length}{Column name in receptor specifying np1 segment length}

\item{np2_length}{Column name in receptor specifying np2 segment length}

\item{amino_acid}{Perform reconstruction on amino acid sequence (experimental)}
}
\value{
List of reconstructed germlines
}
\description{
Reconstruct germlines from alignment data.
}
\details{
Return object contains multiple IMGT-gapped germlines:
\itemize{
  \item  \code{full}:    Full length germline
  \item  \code{dmask}:   Full length germline with D region masked
  \item  \code{vonly}:   V gene segment of germline
  \item  \code{regions}: String showing VDJ segment of each position
}
}
\seealso{
\link{buildClonalGermline}, \link{stitchVDJ}
}
