% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Clones.R
\name{maskSequences}
\alias{maskSequences}
\title{\code{maskSequences} Mask codons split by insertions in V gene}
\usage{
maskSequences(
  data,
  sequence_id = "sequence_id",
  sequence = "sequence",
  sequence_alignment = "sequence_alignment",
  v_sequence_start = "v_sequence_start",
  v_sequence_end = "v_sequence_end",
  v_germline_start = "v_germline_start",
  v_germline_end = "v_germline_end",
  junction_length = "junction_length",
  keep_alignment = FALSE,
  keep_insertions = FALSE,
  mask_codons = TRUE,
  mask_cdr3 = TRUE,
  nproc = 1
)
}
\arguments{
\item{data}{BCR data table}

\item{sequence_id}{sequence id column}

\item{sequence}{input sequence column (query)}

\item{sequence_alignment}{aligned (IMGT-gapped) sequence column (subject)}

\item{v_sequence_start}{V gene start position in sequence}

\item{v_sequence_end}{V gene end position in sequence}

\item{v_germline_start}{V gene start position in sequence_alignment}

\item{v_germline_end}{V gene end position in sequence_alignment}

\item{junction_length}{name of junction_length column}

\item{keep_alignment}{store alignment of query and subject sequences?}

\item{keep_insertions}{return removed insertion sequences?}

\item{mask_codons}{mask split codons?}

\item{mask_cdr3}{mask CDR3 sequences?}

\item{nproc}{number of cores to use}
}
\value{
A tibble with masked sequence in sequence_masked column, 
 as well as other columns.
}
\description{
\code{maskSequences} Mask codons split by insertions in V gene
}
\details{
Performs global alignment of sequence and sequence_alignment, 
masking codons in sequence_alignment that are split by insertions (see examples)
masking_note notes codon positions in subject_alignment sequence that 
were masked, if found.
subject_alignment contains subject sequence aligned to query sequence (only 
if keep_alignment=TRUE)
query_alignment contains query sequence aligned to subject sequence (only if 
keep_alignment=TRUE)
sequence_masked will be NA if frameshift or alignment error detected. This 
will be noted
insertions column will be returned if keep_insertions=TRUE, contains a
comma-separated list of each <position in query alignment>-<sequence>. See example.
in masking_note.
}
\seealso{
\link{maskCodons}, Biostrings::pairwiseAlignment.
}
