% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binarize.R
\name{binarize}
\alias{binarize}
\title{Binarize digital PCR data}
\usage{
binarize(input)
}
\arguments{
\item{input}{object of the class \code{\linkS4class{adpcr}} or
\code{\linkS4class{dpcr}} with one of following types:\code{"ct"}, \code{"fluo"} or
\code{"nm"}.}
}
\value{
object of the class \code{\linkS4class{adpcr}} or
\code{\linkS4class{dpcr}} (depending on \code{input}) with type \code{"np"}.
}
\description{
Transforms multinomial (number of molecules per partition) or continuous (fluorescence)
digital PCR data to binary (positive/negative partition) format.
}
\examples{

#adpcr object
rand_array <- sim_adpcr(200, 300, 100, pos_sums = FALSE, n_panels = 1)
binarize(rand_array)

#dpcr object
rand_droplets <- sim_dpcr(200, 300, 100, pos_sums = FALSE, n_exp = 1)
binarize(rand_droplets)
}
\author{
Michal Burdukiewicz.
}
\keyword{manip}

