% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relocate.R
\name{relocate}
\alias{relocate}
\title{Change column order}
\usage{
relocate(.data, ..., .before = NULL, .after = NULL)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{...}{<\code{\link[=dplyr_tidy_select]{tidy-select}}> Columns to move.}

\item{.before, .after}{<\code{\link[=dplyr_tidy_select]{tidy-select}}> Destination of
columns selected by \code{...}. Supplying neither will move columns to the
left-hand side; specifying both is an error.}
}
\value{
An object of the same type as \code{.data}. The output has the following
properties:
\itemize{
\item Rows are not affected.
\item The same columns appear in the output, but (usually) in a different place.
\item Data frame attributes are preserved.
\item Groups are not affected.
}
}
\description{
Use \code{relocate()} to change column positions, using the same syntax as
\code{select()} to make it easy to move blocks of columns at once.
}
\section{Methods}{

This function is a \strong{generic}, which means that packages can provide
implementations (methods) for other classes. See the documentation of
individual methods for extra arguments and differences in behaviour.

The following methods are currently available in loaded packages:
\Sexpr[stage=render,results=rd]{dplyr:::methods_rd("relocate")}.
}

\examples{
df <- tibble(a = 1, b = 1, c = 1, d = "a", e = "a", f = "a")
df \%>\% relocate(f)
df \%>\% relocate(a, .after = c)
df \%>\% relocate(f, .before = b)
df \%>\% relocate(a, .after = last_col())

# relocated columns can change name
df \%>\% relocate(ff = f)

# Can also select variables based on their type
df \%>\% relocate(where(is.character))
df \%>\% relocate(where(is.numeric), .after = last_col())
# Or with any other select helper
df \%>\% relocate(any_of(c("a", "e", "i", "o", "u")))

# When .before or .after refers to multiple variables they will be
# moved to be immediately before/after the selected variables.
df2 <- tibble(a = 1, b = "a", c = 1, d = "a")
df2 \%>\% relocate(where(is.numeric), .after = where(is.character))
df2 \%>\% relocate(where(is.numeric), .before = where(is.character))
}
