% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{dr4plEst}
\alias{dr4plEst}
\title{Private function to fit the 4PL model to dose-response data}
\usage{
dr4plEst(dose, response, init.parm, trend, method.init, method.optim,
  method.robust, use.Hessian, level, upperl, lowerl)
}
\arguments{
\item{dose}{Vector of dose levels}

\item{response}{Vector of responses}

\item{init.parm}{Vector of initial parameters of the 4PL model supplied by a
user.}

\item{trend}{Indicator of whether a dose-response curve is a decreasing 
\eqn{\theta[3]<0} or increasing curve \eqn{\theta[3]>0}. The default is "auto" 
which indicates that the trend of the curve is automatically determined by
data. The option "decreasing" will impose a restriction \eqn{\theta[3]<=0} 
while the option "increasing" will impose a restriction \eqn{\theta[3]>=0} in an 
optimization process.}

\item{method.init}{Method of obtaining initial values of the parameters.
Should be one of "logistic" for the logistic method or "Mead" for the Mead
method. The default option is the Mead method.}

\item{method.optim}{Method of optimization of the parameters. This argument
is directly delivered to the \code{constrOptim} function provided in the
"base" package of R.}

\item{method.robust}{Parameter to select loss function for the robust estimation 
method to be used to fit a model. The argument NULL indicates the sum of squares
loss, "absolute" indicates the absolute deviation loss, "Huber" indicates Huber's
loss and "Tukey" indicates Tukey's biweight loss.}

\item{use.Hessian}{Indicator of whether the Hessian matrix (TRUE) or the
gradient vector is used in the Hill bounds.}

\item{level}{Confidence level to be used in Hill bounds computation.}

\item{upperl}{upper limit to init.parm}

\item{lowerl}{lower limit to init.parm}
}
\value{
List of final parameter estimates, name of robust estimation, loss value
and so on.
}
\description{
Private function that actually fits the 4PL model to data. If the
  Hill bounds are attained at the end of optimization processes, then an
  indicator of convergence failure so that \code{\link{dr4pl.default}} can
  look for a remedy for convergence failure.
}
