fix_deprecated_plan_names = function(plan){
  if(any(colnames(plan) %in% c("output", "code")))
    warning("Drake is no longer using \"output\" or \"code\" ",
      "for column names in workflow plan data frames. Use \"target\" ",
      "and \"command\" instead.")
  colnames(plan) = gsub("^output$", "target", colnames(plan)) %>%
    gsub(pattern = "^code$", replacement = "command")
  as.data.frame(plan, stringsAsFactors = FALSE)
}

#' @title Deprecated function \code{prune}
#' @description Use \code{\link{clean}()} instead
#' @seealso \code{\link{clean}}, \code{\link{make}}
#' @export
#' @param plan workflow plan data frame, as generated by 
#' \code{\link{plan}}. 
prune = function(plan){
  .Deprecated("clean", package = "drake",
    msg = "prune() is deprecated. Use clean() instead.")
  clean(list = setdiff(built(), possible_targets(plan)))
}
