% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hash_algorithms.R
\name{default_long_hash_algo}
\alias{default_long_hash_algo}
\title{Default long hash algorithm for \code{make()}}
\usage{
default_long_hash_algo(cache = NULL)
}
\arguments{
\item{cache}{optional drake cache.
When you \code{\link{configure_cache}(cache)} without
supplying a long hash algorithm,
\code{default_long_hash_algo(cache)} is the long
hash algorithm that drake picks for you.}
}
\description{
Hashing is advanced. Most users
do not need to know about this function.
}
\details{
The long algorithm must be among \code{\link{available_hash_algos}{}},
which is just the collection of algorithms available to the `algo`
argument in \code{digest::digest()}. \cr \cr

If you express no preference for a hash, drake will use
the long hash for the existing project, or
\code{\link{default_long_hash_algo}()} for a new project.
If you do supply a hash algorithm, it will only apply to
fresh projects (see \code{\link{clean}(destroy = TRUE)}).
For a project that already exists, if you supply a hash algorithm,
drake will warn you and then ignore your choice, opting instead for
the hash algorithm already chosen for the project
in a previous \code{make()}. \cr \cr

Drake uses both a short hash algorithm
and a long hash algorithm. The shorter hash has fewer characters,
and it is used to generate the names of internal cache files
and auxiliary files. The decision for short names is important
because Windows places restrictions on the length of file paths.
On the other hand, some internal hashes in drake are
never used as file names, and those hashes can use a longer hash
to avoid collisions.
}
\examples{
default_long_hash_algo()
}
\seealso{
\code{\link{make}}, \code{\link{available_hash_algos}}
}
