% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strings.R
\name{as_drake_filename}
\alias{as_drake_filename}
\title{Converts an ordinary character string
into a filename understandable by drake.}
\usage{
as_drake_filename(x)
}
\arguments{
\item{x}{character string to be turned into a filename
understandable by drake (i.e., a string with literal
single quotes on both ends).}
}
\value{
A single-quoted character string: i.e., a filename
understandable by drake.
}
\description{
This function simply wraps single quotes around \code{x}.
Quotes are important in drake.
In workflow plan data frame commands,
single-quoted targets denote physical files,
and double-quoted strings are treated as ordinary string literals.
}
\examples{
# Wraps the string in single quotes.
as_drake_filename("my_file.rds") # "'my_file.rds'"
}
