% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_times.R
\name{build_times}
\alias{build_times}
\title{List the time it took to build each target/import.}
\usage{
build_times(path = getwd(), search = TRUE, digits = 3,
  cache = get_cache(path = path, search = search, verbose = verbose),
  targets_only = FALSE, verbose = TRUE, jobs = 1)
}
\arguments{
\item{path}{Root directory of the drake project,
or if \code{search} is \code{TRUE}, either the
project root or a subdirectory of the project.}

\item{search}{logical. If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.}

\item{digits}{How many digits to round the times to.}

\item{cache}{optional drake cache. If supplied,
the \code{path} and \code{search} arguments are ignored.}

\item{targets_only}{logical, whether to only return the
build times of the targets (exclude the imports).}

\item{verbose}{whether to print console messages}

\item{jobs}{number of parallel jobs/workers for light parallelism.}
}
\value{
A data frame of times, each from \code{\link{system.time}()}.
}
\description{
Listed times do not include the amount of time
spent loading and saving objects!
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
# Show the build times for the basic example.
load_basic_example() # Get the code with drake_example("basic").
make(my_plan) # Build all the targets.
build_times() # Show how long it took to build each target.
})
}
}
\seealso{
\code{\link{built}}
}
