% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache_ui.R
\name{imported}
\alias{imported}
\title{List all the imports in the drake cache.}
\usage{
imported(files_only = FALSE, path = getwd(), search = TRUE,
  cache = drake::get_cache(path = path, search = search, verbose = verbose),
  verbose = TRUE, jobs = 1)
}
\arguments{
\item{files_only}{logical, whether to show imported files only
and ignore imported objects. Since all your functions and
all their global variables are imported, the full list of
imported objects could get really cumbersome.}

\item{path}{Root directory of the drake project,
or if \code{search} is \code{TRUE}, either the
project root or a subdirectory of the project.}

\item{search}{logical. If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.}

\item{cache}{drake cache. See \code{\link{new_cache}()}.
If supplied, \code{path} and \code{search} are ignored.}

\item{verbose}{whether to print console messages}

\item{jobs}{number of jobs/workers for parallel processing}
}
\value{
Character vector naming the imports in the cache.
}
\description{
An import is a non-target object processed
by \code{\link{make}()}. Targets in the workflow
plan data frame (see \code{\link{drake_config}()}
may depend on imports.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_basic_example() # Load the canonical example.
make(my_plan) # Run the project, build the targets.
imported() # List all the imported objects/files in the cache.
# For imported files, only the fingerprints/hashes are stored.
})
}
}
\seealso{
\code{\link{cached}}, \code{\link{loadd}},
\code{\link{built}}
}
