% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_graph.R
\name{vis_drake_graph}
\alias{vis_drake_graph}
\alias{drake_graph}
\title{Show an interactive visual network representation
of your drake project.}
\usage{
vis_drake_graph(config, file = character(0), selfcontained = FALSE,
  build_times = TRUE, digits = 3, targets_only = FALSE,
  split_columns = FALSE, font_size = 20, layout = "layout_with_sugiyama",
  main = NULL, direction = "LR", hover = TRUE, navigationButtons = TRUE,
  from = NULL, mode = c("out", "in", "all"), order = NULL,
  subset = NULL, ncol_legend = 1, make_imports = TRUE,
  from_scratch = FALSE, ...)
}
\arguments{
\item{config}{Master configuration list produced by both
\code{\link{make}()} and \code{\link{drake_config}()}.}

\item{file}{Name of HTML file to save the graph.
If \code{NULL} or \code{character(0)},
no file is saved and the graph is rendered and displayed within R.}

\item{selfcontained}{logical, whether to save
the \code{file} as a self-contained
HTML file (with external resources base64 encoded) or a file with
external resources placed in an adjacent directory. If \code{TRUE},
pandoc is required.}

\item{build_times}{logical, whether to print the \code{\link{build_times}()}
in the graph.}

\item{digits}{number of digits for rounding the build times}

\item{targets_only}{logical, whether to skip the imports and only show the
targets in the workflow plan.}

\item{split_columns}{logical, whether to break up the
columns of nodes to make the aspect ratio of the rendered
graph closer to 1:1. This improves the viewing experience,
but the columns no longer strictly represent parallelizable
stages of build items. (Although the targets/imports
in each column are still conditionally independent,
there may be more conditional independence than the graph
indicates.)}

\item{font_size}{numeric, font size of the node labels in the graph}

\item{layout}{name of an igraph layout
to use, such as 'layout_with_sugiyama'
or 'layout_as_tree'. Be careful with
'layout_as_tree': the graph is a directed
acyclic graph, but not necessarily a tree.}

\item{main}{title of the graph}

\item{direction}{an argument to
\code{visNetwork::visHierarchicalLayout()}
indicating the direction of the graph.
Options include 'LR', 'RL', 'DU', and 'UD'.
At the time of writing this, the letters must be capitalized,
but this may not always be the case ;) in the future.}

\item{hover}{logical, whether to show the command that generated the target
when you hover over a node with the mouse. For imports, the label does not
change with hovering.}

\item{navigationButtons}{logical, whether to add navigation buttons with
\code{visNetwork::visInteraction(navigationButtons = TRUE)}}

\item{from}{Optional character vector of target/import names.
If \code{from} is nonempty,
the graph will restrict itself to
a neighborhood of \code{from}.
Control the neighborhood with
\code{mode} and \code{order}.}

\item{mode}{Which direction to branch out in the graph
to create a neighborhood around \code{from}.
Use \code{"in"} to go upstream,
\code{"out"} to go downstream,
and \code{"all"} to go both ways and disregard
edge direction altogether.}

\item{order}{How far to branch out to create
a neighborhood around \code{from} (measured
in the number of nodes). Defaults to
as far as possible.}

\item{subset}{Optional character vector of of target/import names.
Subset of nodes to display in the graph.
Applied after \code{from}, \code{mode}, and \code{order}.
Be advised: edges are only kept for adjacent nodes in \code{subset}.
If you do not select all the intermediate nodes,
edges will drop from the graph.}

\item{ncol_legend}{number of columns in the legend nodes}

\item{make_imports}{logical, whether to import external files
and objects from the user's workspace to determine
which targets are up to date. If \code{FALSE}, the computation
is faster, but all the relevant information is drawn from the cache
and may be out of date.}

\item{from_scratch}{logical, whether to assume all the targets
will be made from scratch on the next \code{\link{make}()}.
Makes all targets outdated, but keeps information about
build progress in previous \code{\link{make}()}s.}

\item{...}{other arguments passed to
\code{visNetwork::visNetwork()} to plot the graph.}
}
\value{
A visNetwork graph.
}
\description{
To save time for repeated plotting,
this function is divided into
\code{\link{dataframes_graph}()} and \code{\link{render_drake_graph}()}.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
config <- load_basic_example() # Get the code with drake_example("basic").
# Plot the network graph representation of the workflow.
vis_drake_graph(config, width = '100\%') # The width is passed to visNetwork
config <- make(my_plan) # Run the project, build the targets.
vis_drake_graph(config) # The red nodes from before are now green.
# Plot a subgraph of the workflow.
vis_drake_graph(
  config,
  from = c("small", "reg2"),
  to = "summ_regression2_small"
)
})
}
}
\seealso{
\code{\link{build_drake_graph}}
}
