% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/staged_parallelism.R
\name{parallel_stages}
\alias{parallel_stages}
\title{Show how \code{\link[=make]{make()}} will build your targets
in successive parallelizable stages.}
\usage{
parallel_stages(config = drake::read_drake_config(), from_scratch = FALSE)
}
\arguments{
\item{config}{An configuration list output by
\code{\link[=make]{make()}} or \code{\link[=drake_config]{drake_config()}}.}

\item{from_scratch}{logical, whether to assume
that the next \code{\link[=make]{make()}} will run from scratch
so that all targets are attempted.}
}
\value{
A data frame of information spelling out how
targets are divided into parallelizable stages
(according to the \code{stage} column).
}
\description{
The stages determine the order in which
\code{\link[=make]{make()}} builds the targets.
}
\details{
Usually, \code{\link[=make]{make()}} divides the targets
and imports into parallelizable stages strictly according
to the columns in \code{\link[=vis_drake_graph]{vis_drake_graph()}}.
However, if some targets are out of date, drake
looks ahead in the graph until it finds outdated targets
for the current stage. The \code{parallel_stages()} function
takes this behavior into account when it reports a data frame
of information on how targets and imports will be divided into
parallel stages during the next \code{\link[=make]{make()}}.
}
\examples{
  \dontrun{
  test_with_dir("Quarantine side effects.", {
  load_basic_example() # Get the code with drake_example("basic").
  config <- drake_config(my_plan) # Get a configuration list.
  # Parallel stages for the next make().
  parallel_stages(config = config)
  # Check the graph to see that the information agrees.
  vis_drake_graph(config = config)
  # Build the project.
  config <- make_with_config(config) # or make(my_plan)
  # Nothing to build in the next make().
  parallel_stages(config = config)
  # Change a dependency and notice how the stages change.
  reg2 = function(d){
    d$x3 = d$x^3
    lm(y ~ x3, data = d)
  }
  parallel_stages(config = config)
  })
  }
}
\seealso{
\code{\link[=next_stage]{next_stage()}},
\code{\link[=make]{make()}}, \code{\link[=make_with_config]{make_with_config()}}
}
