% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-deprecate.R
\name{drake_cache_log_file}
\alias{drake_cache_log_file}
\title{Deprecated. Generate a flat text log file to represent the state of
the cache.}
\usage{
drake_cache_log_file(file = "drake_cache.log", path = getwd(),
  search = TRUE, cache = drake::get_cache(path = path, search = search,
  verbose = verbose), verbose = 1L, jobs = 1L, targets_only = FALSE)
}
\arguments{
\item{file}{character scalar, name of the flat text log file.}

\item{path}{Root directory of the drake project,
or if \code{search} is \code{TRUE}, either the
project root or a subdirectory of the project.
Ignored if a \code{cache} is supplied.}

\item{search}{Logical. If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.
Ignored if a \code{cache} is supplied.}

\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} and \code{search} are ignored.}

\item{verbose}{Logical or numeric, control printing to the console.
\itemize{
\item \code{0} or \code{FALSE}: print nothing.
\item \code{1} or \code{TRUE}: print only targets to build.
\item \code{2}: plus checks and cache info.
\item \code{3}: plus missing imports.
\item \code{4}: plus all imports.
\item \code{5}: plus execution and total build times for targets.
\item \code{6}: plus notifications when targets are being stored.
}}

\item{jobs}{Number of jobs/workers for parallel processing.}

\item{targets_only}{Logical, whether to output information only on the
targets in your workflow plan data frame. If \code{targets_only} is \code{FALSE}, the
output will include the hashes of both targets and imports.}
}
\value{
There is no return value, but a log file is generated.
}
\description{
Deprecated on 2019-03-09.
}
\details{
Calling this function to create a log file and later calling
\code{make()} makes the log file out of date. Therefore, we recommend using
\code{make()} with the \code{cache_log_file} argument to create the cache log. This
way ensures that the log is always up to date with \code{make()} results.
}
\examples{
# Deprecated
}
\seealso{
\code{\link[=drake_cache_log]{drake_cache_log()}}, \code{\link[=make]{make()}}, \code{\link[=get_cache]{get_cache()}}
}
\keyword{internal}
