% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-debug.R
\name{drake_debug}
\alias{drake_debug}
\title{Run a single target's command in debug mode.}
\usage{
drake_debug(target = NULL, config = NULL, character_only = FALSE,
  envir = NULL, jobs = 1, replace = FALSE, verbose = TRUE)
}
\arguments{
\item{target}{Name of the target.}

\item{config}{Internal configuration list.}

\item{character_only}{Logical, whether \code{name} should be treated
as a character or a symbol
(just like \code{character.only} in \code{\link[=library]{library()}}).}

\item{envir}{Environment to load objects into. Defaults to the
calling environment (current workspace).}

\item{jobs}{Number of parallel jobs for loading objects. On
non-Windows systems, the loading process for multiple objects
can be lightly parallelized via \code{parallel::mclapply()}.
just set jobs to be an integer greater than 1. On Windows,
\code{jobs} is automatically demoted to 1.}

\item{replace}{Logical. If \code{FALSE},
items already in your environment
will not be replaced.}

\item{verbose}{Logical, whether to print out the target
you are debugging.}
}
\value{
The value of the target right after it is built.
}
\description{
\code{drake_debug()} loads a target's dependencies
and then runs its command in debug mode (see \code{browser()},
\code{debug()}, and \code{debugonce()}). This function does not
store the target's value in the cache
(see \url{https://github.com/ropensci/drake/issues/587}).
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
# This example is not really a user-side demonstration.
# It just walks through a dive into the internals.
# Populate your workspace and write 'report.Rmd'.
load_mtcars_example() # Get the code with drake_example("mtcars").
# Create the master internal configuration list.
config <- drake_config(my_plan)
out <- drake_build(small, config = config)
# Now includes `small`.
cached()
head(readd(small))
# `small` was invisibly returned.
head(out)
# If you previously called make(),
# `config` is just read from the cache.
make(my_plan, verbose = FALSE)
result <- drake_build(small, config = config)
head(result)
}
})
}
}
\seealso{
\code{\link[=drake_build]{drake_build()}}
}
