% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-plan.R
\name{knitr_in}
\alias{knitr_in}
\title{Declare \code{knitr}/\code{rmarkdown} source files
as dependencies.}
\usage{
knitr_in(...)
}
\arguments{
\item{...}{Character strings. File paths of \code{knitr}/\code{rmarkdown}
source files supplied to a command in your workflow plan data frame.}
}
\value{
A character vector of declared input file paths.
}
\description{
\code{knitr_in()} marks individual \code{knitr}/R Markdown
reports as dependencies. In \code{drake}, these reports are pieces
of the pipeline. R Markdown is a great tool for \emph{displaying}
precomputed results, but not for running a large workflow
from end to end. These reports should do as little
computation as possible.
}
\details{
Unlike \code{\link[=file_in]{file_in()}} and \code{\link[=file_out]{file_out()}}, \code{knitr_in()}
does not work with entire directories.
}
\examples{
\dontrun{
isolate_example("Contain side effects", {
if (suppressWarnings(require("knitr"))) {
# `knitr_in()` is like `file_in()`
# except that it analyzes active code chunks in your `knitr`
# source file and detects non-file dependencies.
# That way, updates to the right dependencies trigger rebuilds
# in your report.
# The mtcars example (`drake_example("mtcars")`)
# already has a demonstration
load_mtcars_example()
make(my_plan)
# Now how did drake magically know that
# `small`, `large`, and `coef_regression2_small` were
# dependencies of the output file `report.md`?
# because the command in the workflow plan had
# `knitr_in("report.Rmd")` in it, so drake knew
# to analyze the active code chunks. There, it spotted
# where `small`, `large`, and `coef_regression2_small`
# were read from the cache using calls to `loadd()` and `readd()`.
}
})
}
}
\seealso{
\code{\link[=file_in]{file_in()}}, \code{\link[=file_out]{file_out()}}, \code{\link[=ignore]{ignore()}}
}
