% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{failed}
\alias{failed}
\title{List failed targets.
\lifecycle{maturing}}
\usage{
failed(
  path = NULL,
  search = NULL,
  cache = drake::drake_cache(path = path),
  verbose = 1L,
  upstream_only = NULL
)
}
\arguments{
\item{path}{Path to a \code{drake} cache
(usually a hidden \verb{.drake/} folder) or \code{NULL}.}

\item{search}{Deprecated.}

\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} is ignored.}

\item{verbose}{Deprecated on 2019-09-11.}

\item{upstream_only}{Deprecated.}
}
\value{
A character vector of target names.
}
\description{
Together, functions \code{failed()} and
\code{\link[=diagnose]{diagnose()}} should eliminate the strict need
for ordinary error messages printed to the console.
}
\examples{
\dontrun{
isolate_example("contain side effects", {
if (suppressWarnings(require("knitr"))) {
# Build a plan doomed to fail:
bad_plan <- drake_plan(x = function_doesnt_exist())
cache <- storr::storr_environment() # optional
try(
  make(bad_plan, cache = cache, history = FALSE),
  silent = TRUE
) # error
failed(cache = cache) # "x"
e <- diagnose(x, cache = cache) # Retrieve the cached error log of x.
names(e)
e$error
names(e$error)
}
})
}
}
\seealso{
\code{\link[=running]{running()}}, \code{\link[=make]{make()}}
}
