% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outdated.R
\name{outdated}
\alias{outdated}
\title{List the targets that are out of date.
\lifecycle{stable}}
\usage{
outdated(config, make_imports = TRUE, do_prework = TRUE)
}
\arguments{
\item{config}{A configured workflow from \code{\link[=drake_config]{drake_config()}}.}

\item{make_imports}{Logical, whether to make the imports first.
Set to \code{FALSE} to save some time and risk obsolete output.}

\item{do_prework}{Whether to do the \code{prework}
normally supplied to \code{\link[=make]{make()}}.}
}
\value{
Character vector of the names of outdated targets.
}
\description{
Outdated targets will be rebuilt in the next
\code{\link[=make]{make()}}. \code{outdated()} does not show dynamic sub-targets.
}
\examples{
\dontrun{
isolate_example("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
load_mtcars_example() # Get the code with drake_example("mtcars").
# Recopute the config list early and often to have the
# most current information. Do not modify the config list by hand.
config <- drake_config(my_plan)
outdated(config = config) # Which targets are out of date?
make(my_plan) # Run the projects, build the targets.
config <- drake_config(my_plan)
# Now, everything should be up to date (no targets listed).
outdated(config = config)
}
})
}
}
\seealso{
\code{\link[=r_outdated]{r_outdated()}}, \code{\link[=drake_config]{drake_config()}}, \code{\link[=missed]{missed()}}, \code{\link[=drake_plan]{drake_plan()}},
\code{\link[=make]{make()}}
}
