% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cluster}
\alias{cluster}
\title{classification variable}
\usage{
cluster(U)
}
\arguments{
\item{U}{Binary and row-stochastic matrix.}
}
\value{
\item{cl}{vector of length n indicating, for each element, the index of the cluster to which it has been assigned.}
}
\description{
Recodes the binary and row-stochastic membership matrix U into the classification variable (similar to the "cluster" output returned by kmeans()).
}
\examples{
# Iris data 
# Loading the numeric variables of iris data
iris <- as.matrix(iris[,-5]) 

# standardizing the data
iris <- scale(iris)

# double k-means with 3 unit-clusters and 2 components for the variables
p1 <- redkm(iris, K = 3, Q = 2)
cl <- cluster(p1$U)

}
\author{
Ionel Prunila, Maurizio Vichi
}
