% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic6.R
\name{logistic6_fn}
\alias{logistic6_fn}
\title{6-parameter logistic function}
\usage{
logistic6_fn(x, theta)
}
\arguments{
\item{x}{numeric vector at which the function is to be evaluated.}

\item{theta}{numeric vector with the six parameters in the form
\code{c(alpha, delta, eta, phi, nu, xi)}.}
}
\value{
Numeric vector of the same length of \code{x} with the values of the
logistic function.
}
\description{
Evaluate at a particular set of parameters the 6-parameter logistic function.
}
\details{
The 6-parameter logistic function \verb{f(x; theta)} is defined here as

\verb{g(x; theta) = 1 / (xi + nu * exp(-eta * (x - phi)))^(1 / nu)}
\verb{f(x; theta) = alpha + delta g(x; theta)}

where \code{theta = c(alpha, delta, eta, phi, nu, xi)}, \code{eta > 0}, \code{nu > 0}, and
\code{xi > 0}. When \code{delta} is positive (negative) the curve is monotonically
increasing (decreasing).

Parameter \code{alpha} is the value of the function when \code{x -> -Inf}.
Parameter \code{delta} affects the value of the function when \code{x -> Inf}.
Parameter \code{eta} represents the steepness (growth rate) of the curve.
Parameter \code{phi} is related to the mid-value of the function.
Parameter \code{nu} affects near which asymptote maximum growth occurs.
Parameter \code{xi} affects the value of the function when \code{x -> Inf}.

\strong{Note}: The 6-parameter logistic function is over-parameterized and
non-identifiable from data. It is available only for theoretical research.
}
