% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dseries.R
\name{dseries}
\alias{dseries}
\title{Completes multiple series of simulated drop tests.}
\usage{
dseries(num.series, tag.group = FALSE, group = 0, ...)
}
\arguments{
\item{num.series}{Integer. Specifies how many series of drop tests to
simulate.}

\item{tag.group}{Logical. If \code{TRUE}, group number is included in
output data table. Default is \code{FALSE}.}

\item{group}{Integer. Assigns a group number to each simulated drop test
within the same series. Only if \code{tag.group} is \code{TRUE}. Default
is 0.}

\item{...}{Passes \code{q}, \code{max.trials}, \code{fail.criteria},
and \code{fail.criteria} to \code{dtrials}. All are optional except
\code{q}.}
}
\value{
Data table of multiple simulated drop tests. 
  Each row of the data.table represents one simulated drop test. 
  Containing the following elements:
  
\itemize{  
 \item \strong{F_CRITERIA} The failure criteria specified.
 
 \item \strong{REACT} The total number of simulated reactions (failures).
 
 \item \strong{NON_REACT} The total number of simulated non-reactions
  (successes).
  
 \item \strong{TRIALS} The number of simulated trials performed until
  failure condition met.
  
 \item \strong{MAX_TRIALS} The maximum number of simulated trials to
  perform as specified.
  
 \item \strong{PCT_REACT} The the percent of simulated trials that yielded
  a reaction (failure).
  
 \item \strong{Q} The probability of failure (reaction) as specified.
 
 \item \strong{P} The probability of success (non-reaction).
 
 \item \strong{RESULT} Whether the simulated test series as a whole
  failed or passed based on the failure criteria specified.
}
}
\description{
\code{dseries} returns a series of simulated drop tests. Where each test
consists of trials (drops).
}
\examples{
  dseries(num.series = 5, q = 0.05)
  dseries(num.series = 5, q = 0.05, max.trials = 60)
  dseries(num.series = 5, q = 0.05, max.trials = 60, fail.criteria = 2)
  
}
\seealso{
\code{\link{dtrials}}
  \code{\link{droptest}}
}
\author{
Chad Ross \email{chad.ross@gmail.com}
}
