% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_dispensing_models.R
\name{f_fit_ki}
\alias{f_fit_ki}
\title{Count Model Fit for Number of Skipped Visits}
\usage{
f_fit_ki(df, model, nreps, showplot = TRUE)
}
\arguments{
\item{df}{The subject-level dosing data, including \code{skipped} to
indicate the number of skipped visits.}

\item{model}{The count model used to analyze the number of
skipped visits, with options including
"constant", "poisson", "zip" for zero-inflated Poisson, and
"zinb" for zero-inflated negative binomial.}

\item{nreps}{The number of simulations for drawing posterior model
parameter values.}

\item{showplot}{A Boolean variable that controls whether or not to
show the fitted count bar chart. It defaults to \code{TRUE}.}
}
\value{
A list of results from the model fit that includes

* \code{model}: The specific model used in the analysis.

* \code{theta}: The estimated model parameters.

* \code{vtheta}: The estimated covariance matrix of \code{theta}.

* \code{aic}: The Akaike Information Criterion value for the model fit.

* \code{bic}: The Bayesian Information Criterion value for the model fit.

Additionally, the function provides:

* A fitted count bar chart.

* Posterior draws of model parameters.
}
\description{
Fits a count model to the number of skipped visits.
}
\examples{
library(dplyr)

df <- df2 \%>\%
mutate(arrivalTime = as.numeric(randdt - trialsdt + 1))

vf <- visitview2 \%>\%
  inner_join(df, by = "usubjid") \%>\%
  mutate(day = as.numeric(date - randdt + 1)) \%>\%
  select(drug, drug_name, dose_unit, usubjid, treatment,
         treatment_description, arrivalTime,
         time, event, dropout, day, dispensed_quantity) \%>\%
  group_by(drug, drug_name, dose_unit, usubjid, treatment,
           treatment_description, arrivalTime,
           time, event, dropout, day) \%>\%
  summarise(dose = sum(dispensed_quantity),
            .groups = "drop_last") \%>\%
  mutate(cum_dose = cumsum(dose)) \%>\%
  group_by(drug, drug_name, dose_unit, usubjid) \%>\%
  mutate(row_id = row_number())

vf <- vf \%>\%
  left_join(dosing_schedule_df, by = "drug")

# time from randomization to the first drug dispensing visit
df_k0 <- vf \%>\%
  filter(row_id == 1) \%>\%
  mutate(time = day,
         skipped = floor((time - target_days/2)/target_days) + 1)

fit_k0 <- f_fit_ki(df_k0, model = "zip", nreps = 200)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
