% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_multitrial_binary.R
\name{EPsProg_multitrial_binary}
\alias{EPsProg_multitrial_binary}
\alias{EPsProg2_binary}
\alias{EPsProg3_binary}
\alias{EPsProg4_binary}
\title{Expected probability of a successful program for multitrial programs with binary distributed outcomes}
\usage{
EPsProg2_binary(
  RRgo,
  n2,
  alpha,
  beta,
  p0,
  w,
  p11,
  p12,
  in1,
  in2,
  case,
  size,
  fixed
)

EPsProg3_binary(
  RRgo,
  n2,
  alpha,
  beta,
  p0,
  w,
  p11,
  p12,
  in1,
  in2,
  case,
  size,
  fixed
)

EPsProg4_binary(
  RRgo,
  n2,
  alpha,
  beta,
  p0,
  w,
  p11,
  p12,
  in1,
  in2,
  case,
  size,
  fixed
)
}
\arguments{
\item{RRgo}{threshold value for the go/no-go decision rule}

\item{n2}{total sample size for phase II; must be even number}

\item{alpha}{significance level}

\item{beta}{1-beta power for calculation of sample size for phase III}

\item{p0}{assumed true rate of control group}

\item{w}{weight for mixture prior distribution}

\item{p11}{assumed true rate of treatment group}

\item{p12}{assumed true rate of treatment group}

\item{in1}{amount of information for p11 in terms of sample size}

\item{in2}{amount of information for p12 in terms of sample size}

\item{case}{choose case: "at least 1, 2 or 3 significant trials needed for approval"}

\item{size}{size category "small", "medium" or "large"}

\item{fixed}{choose if true treatment effects are fixed or random}
}
\value{
The output of the function EPsProg2_binary(), EPsProg3_binary() and EPsProg4_binary() is the expected probability of a successful program when performing several phase III trials (2, 3 or 4 respectively)
}
\description{
These functions calculate the expected probability of a successful program given the parameters.
Each function represents a specific strategy, e.g. the function EpsProg3_binary() calculates the expected probability if three phase III trials are performed.
The parameter case specifies how many of the trials have to be successful, i.e. how many trials show a significantly relevant positive treatment effect.
}
\details{
The following cases can be investigated by the software:
\itemize{
\item Two phase III trials
\itemize{
\item Case 1: Strategy 1/2; at least one trial significant, the treatment effect of the other one at least showing in the same direction
\item Case 2: Strategy 2/2; both trials significant
}
\item Three phase III trials
\itemize{
\item Case 2: Strategy 2/3; at least two trials significant, the treatment effect of the other one at least showing in the same direction
\item Case 3: Strategy 3/3; all trials significant
}
\item Four phase III trials
\itemize{
\item Case 3: Strategy 3/4; at least three trials significant, the treatment effect of the other one at least showing in the same direction
}
}
}
\examples{
\donttest{EPsProg2_binary(RRgo = 0.8, n2 = 50,  alpha = 0.025, beta = 0.1, 
                                 p0 = 0.6,  w = 0.3, p11 =  0.3, p12 = 0.5, 
                                 in1 = 300, in2 = 600, case = 2, size = "small",
                                 fixed = FALSE)}
          \donttest{EPsProg3_binary(RRgo = 0.8, n2 = 50,  alpha = 0.025, beta = 0.1, 
                                 p0 = 0.6,  w = 0.3, p11 =  0.3, p12 = 0.5, 
                                 in1 = 300, in2 = 600, case = 2, size = "small",
                                 fixed = FALSE)}
          \donttest{EPsProg4_binary(RRgo = 0.8, n2 = 50,  alpha = 0.025, beta = 0.1, 
                                 p0 = 0.6,  w = 0.3, p11 =  0.3, p12 = 0.5, 
                                 in1 = 300, in2 = 600, case = 3, size = "small",
                                 fixed = FALSE)}
}
\keyword{internal}
