% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_bias.R
\name{Epgo_bias}
\alias{Epgo_bias}
\alias{Epgo_L2}
\alias{Epgo_R2}
\title{Expected probability to go to phase III for bias adjustment programs with time-to-event outcomes}
\usage{
Epgo_L2(HRgo, d2, Adj, w, hr1, hr2, id1, id2, fixed)

Epgo_R2(HRgo, d2, Adj, w, hr1, hr2, id1, id2, fixed)
}
\arguments{
\item{HRgo}{threshold value for the go/no-go decision rule}

\item{d2}{total number of events for phase II; must be even number}

\item{Adj}{adjustment parameter}

\item{w}{weight for mixture prior distribution}

\item{hr1}{first assumed true treatment effect on HR scale for prior distribution}

\item{hr2}{second assumed true treatment effect on HR scale for prior distribution}

\item{id1}{amount of information for \code{hr1} in terms of number of events}

\item{id2}{amount of information for \code{hr2} in terms of number of events}

\item{fixed}{choose if true treatment effects are fixed or random, if TRUE \code{hr1} is used as fixed effect}
}
\value{
The output of the functions \code{Epgo_L2} and \code{Epgo_R2} is the expected probability to go to phase III with conservative decision rule and sample size calculation.
}
\description{
In the case we do not only want do discount for overoptimistic results in phase II when calculating the sample size in phase III,
but also when deciding whether to go to phase III or not the functions \code{Epgo_L2} and \code{Epgo_R2} are necessary.
The function \code{Epgo_L2} uses an additive adjustment parameter (i.e. adjust the lower bound of the one-sided confidence interval),
the function \code{Epgo_R2} uses a multiplicative adjustment parameter (i.e. use estimate with a retention factor)
}
\examples{
res <- Epgo_L2(HRgo = 0.8, d2 = 50, Adj = 0.4,  
                                w = 0.3, hr1 = 0.69, hr2 = 0.81, 
                                id1 = 280, id2 = 420, fixed = FALSE)
          res <- Epgo_R2(HRgo = 0.8, d2 = 50, Adj = 0.9,  
                                w = 0.3, hr1 = 0.69, hr2 = 0.81, 
                                id1 = 280, id2 = 420, fixed = FALSE)
}
\keyword{internal}
