% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_multitrial.R
\name{utility23}
\alias{utility23}
\title{Utility function for multitrial programs deciding between two or three phase III trials in a time-to-event setting}
\usage{
utility23(
  d2,
  HRgo,
  w,
  hr1,
  hr2,
  id1,
  id2,
  alpha,
  beta,
  xi2,
  xi3,
  c2,
  c3,
  c02,
  c03,
  b1,
  b2,
  b3
)
}
\arguments{
\item{d2}{total sample size for phase II; must be even number}

\item{HRgo}{threshold value for the go/no-go decision rule}

\item{w}{weight for mixture prior distribution}

\item{hr1}{first assumed true treatment effect on HR scale for prior distribution}

\item{hr2}{second assumed true treatment effect on HR scale for prior distribution}

\item{id1}{amount of information for \code{hr1} in terms of number of events}

\item{id2}{amount of information for \code{hr2} in terms of number of events}

\item{alpha}{significance level}

\item{beta}{\code{1-beta} power for calculation of sample size for phase III}

\item{xi2}{event rate for phase II}

\item{xi3}{event rate for phase III}

\item{c2}{variable per-patient cost for phase II}

\item{c3}{variable per-patient cost for phase III}

\item{c02}{fixed cost for phase II}

\item{c03}{fixed cost for phase III}

\item{b1}{expected gain for effect size category \code{"small"}}

\item{b2}{expected gain for effect size category \code{"medium"}}

\item{b3}{expected gain for effect size category \code{"large"}}
}
\value{
The output of the function \code{utility23()} is the expected utility of the program depending on whether two or three phase III trials are performed.
}
\description{
The utility function calculates the expected utility of our drug development program and is given as gains minus costs and depends on the parameters and the expected probability of a successful program.
The utility is in further step maximized by the \code{optimal_multitrial()} function.
}
\examples{
\donttest{utility23(d2 = 50, HRgo = 0.8,  w = 0.3, 
                                 hr1 =  0.69, hr2 = 0.81, 
                                 id1 = 280, id2 = 420, 
                                 alpha = 0.025, beta = 0.1, xi2 = 0.7, xi3 = 0.7,
                                 c2 = 0.75, c3 = 1, c02 = 100, c03 = 150,
                                 b1 = 1000, b2 = 2000, b3 = 3000)}
}
\keyword{internal}
