% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expmodel.r
\name{func.expmodel}
\alias{func.expmodel}
\title{Return the evaluation of a vector with Exponential-based
model}
\usage{
\method{func}{expmodel}(model, x, cdf = FALSE, n = 1, ...)
}
\arguments{
\item{model}{\code{expmodel} object.}

\item{x}{A numeric vector to be evaluated with a distribution.}

\item{cdf}{A logical scalar whether the evaluation is done with a cumulative
distribution or not. A default value is \code{FALSE}, which means that the
evaluation is done with a density.}

\item{n}{The index indicates the estimates. 1, by default, is the best
estimate, and 2 is the 2nd best, etc.}

\item{...}{Arguments to be passed to or from other methods.}
}
\value{
A numeric vector of the evaluatio of input vector \code{x} with a model.
}
\description{
Evaluate an input vector \code{x} with Exponential-based model and
return its vector.
By default, it evaluate with the best model and its density, but
it can designate the model by index and also can evaluate with a cumulative
distribution.
}
\examples{
## Create an `expmodel` object
emodel <- expmodel(mixexpgamma$n200)
## Estimate an model with parameters
emodel <- estimate(emodel, deglist=5, lmdlist=3.75)
## A vector for input
x <- seq(0, 14, by=0.1)
## Density function
y <- func(emodel, x)
## Cumulative distribution
y <- func(emodel, x, cdf=TRUE)
}
\seealso{
\code{\link[=expmodel]{expmodel()}} \code{\link[=summary.expmodel]{summary.expmodel()}} \code{\link[=plot.expmodel]{plot.expmodel()}}
\code{\link[=estimate.expmodel]{estimate.expmodel()}} \code{\link[=pdf_expmodel]{pdf_expmodel()}} \code{\link[=cdf_expmodel]{cdf_expmodel()}}
}
