% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/par2mom.R
\name{par2mom}
\alias{par2mom}
\title{Parameter to Moments}
\usage{
par2mom(mu = 0, sigma_v = 1, sigma_u = 1, s = -1, distr = "normhnorm")
}
\arguments{
\item{mu}{numeric vector of \eqn{\mu}.}

\item{sigma_v}{numeric vector of \eqn{\sigma_V}. Must be positive.}

\item{sigma_u}{numeric vector of \eqn{\sigma_U}. Must be positive.}

\item{s}{integer; \eqn{s=-1} for production and \eqn{s=1} for cost function.}

\item{distr}{string; determines the distribution:\cr
`normhnorm`, Normal-halfnormal distribution \cr
`normexp`, Normal-exponential distribution \cr}
}
\value{
Returns a matrix where the first column corresponds to the mean, the second to the standard deviation and the third to the skewness.
}
\description{
Calculates the moments of composed-error distribution based on the provided parameters.
}
\details{
See \code{\link{dcomper}} for details of the distribution. For the inverse transformation see \code{\link{mom2par}}.
}
\examples{
par2mom(mu=0, sigma_v=1, sigma_u=1, s=-1, distr="normhnorm")
par2mom(mu=0, sigma_v=1, sigma_u=1, s=-1, distr="normexp")

}
