% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{trind_generator}
\alias{trind_generator}
\title{Trind_generator function}
\usage{
trind_generator(K)
}
\arguments{
\item{K}{integer; determines the number of parameters.}
}
\value{
Returns a list with index matrices for the first to fourth derivative, which can be accessed via the function [trind()].
The numerical vectors \code{i_start} and \code{i_end} hold the starting and ending indexes, which are required by [trind()] for derivatives greater than two.
}
\description{
Generates index matrices for upper triangular storage up to order four.
}
\details{
Useful when working with higher order derivatives, which generate symmetric arrays. Mainly intended for internal use. Similar to 'mgcv::trind.generator'. Mostly internal function.
}
\examples{
tri<-trind_generator(3)
tri_mgcv<-mgcv::trind.generator(3)

for(i in 1:3){
  print(i==trind(tri, part_deriv_var=c(i)-1)+1)
  for(j in i:3){
    print(tri_mgcv$i2[i,j]==trind(tri, part_deriv_var=c(i,j)-1)+1)
    for(k in j:3){
      print(tri_mgcv$i3[i,j,k]==trind(tri, part_deriv_var=c(i,j,k)-1)+1)
      for(l in k:3){
        print(tri_mgcv$i4[i,j,k,l]==trind(tri, part_deriv_var=c(i,j,k,l)-1)+1)
      } 
    } 
  }
}

}
\seealso{
Other derivs: 
\code{\link{chainrule}()},
\code{\link{derivs_transform}()},
\code{\link{differencerule}()},
\code{\link{ind2joint}()},
\code{\link{list2derivs}()},
\code{\link{productrule}()},
\code{\link{quotientrule}()},
\code{\link{sumrule}()},
\code{\link{trind}()}
}
\concept{derivs}
