% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsm_varprop.R
\name{dsm_varprop}
\alias{dsm_varprop}
\title{Variance propagation for density surface models}
\usage{
dsm_varprop(model, newdata, trace = FALSE, var_type = "Vp")
}
\arguments{
\item{model}{a fitted \code{\link{dsm}}}

\item{newdata}{the prediction grid}

\item{trace}{for debugging, see how the scale parameter estimation is going}

\item{var_type}{which variance-covariance matrix should be used (\code{"Vp"} for variance-covariance conditional on smoothing parameter(s), \code{"Vc"} for unconditional). See \code{\link{gamObject}} for an details/explanation. If in doubt, stick with the default, \code{"Vp"}.}
}
\value{
a list with elements
\tabular{ll}{\code{old_model} \tab fitted model supplied to the function as \code{model}\cr
             \code{refit} \tab refitted model object, with extra term\cr
             \code{pred} \tab point estimates of predictions at \code{newdata}\cr
             \code{var} \tab total variance calculated over all of \code{newdata}\cr
             \code{ses} \tab standard error for each prediction cell in \code{newdata}\cr
 }
}
\description{
Calculate the uncertainty in predictions from a fitted DSM, including uncertainty from the detection function.
}
\details{
When we make predictions from a spatial model, we also want to know the uncertainty about that abundance estimate. Since density surface models are 2 (or more) stage models, we need to incorporate the uncertainty from the earlier stages (i.e. the detection function) into our "final" uncertainty estimate.

This function will refit the spatial model but include the Hessian of the offset as an extra term. Variance estimates using this new model can then be used to calculate the variance of predicted abundance estimates which incorporate detection function uncertainty. Importantly this requires that if the detection function has covariates, then these do not vary within a segment (so, for example covariates like sex cannot be used).

For more information on how to construct the prediction grid \code{data.frame}, \code{newdata}, see \code{\link{predict.dsm}}.

This routine is only useful if a detection function with covariates has been used in the DSM.

Note that we can use \code{var_type="Vc"} here (see \code{\link{gamObject}}), which is the variance-covariance matrix for the spatial model, corrected for smoothing parameter uncertainty. See Wood, Pya & S{\"a}fken (2016) for more information.

Negative binomial models fitted using the \code{\link{nb}} family will give strange results (overly big variance estimates due to scale parameter issues) so \code{nb} models are automatically refitted with \code{\link{negbin}} (with a warning). It is probably worth refitting these models with \code{negbin} manually (perhaps giving a smallish range of possible values for the negative binomial parameter) to check that convergence was reached.
}
\section{Diagnostics}{

The summary output from the function includes a simply diagnostic that shows the average probability of detection from the "original" fitted model (the model supplied to this function; column \code{Fitted.model}) and the probability of detection from the refitted model (used for variance propagation; column \code{Refitted.model}) along with the standard error of the probability of detection from the fitted model (\code{Fitted.model.se}), at the unique values of any factor covariates used in the detection function (for continous covariates the 5%, 50% and 95% quantiles are shown). If there are large differences between the probabilities of detection then there are potentially problems with the fitted model, the variance propagation or both. This can be because the fitted model does not account for enough of the variability in the data and in refitting the variance model accounts for this in the random effect.
}

\references{
Williams, R., Hedley, S.L., Branch, T.A., Bravington, M.V., Zerbini, A.N. and Findlay, K.P. (2011). Chilean Blue Whales as a Case Study to Illustrate Methods to Estimate Abundance and Evaluate Conservation Status of Rare Species. Conservation Biology 25(3), 526-535.

Wood, S.N., Pya, N. and S{\"a}fken, B. (2016) Smoothing parameter and model selection for general smooth models. Journal of the American Statistical Association, 1-45.
}
\author{
David L. Miller, based on code from Mark V. Bravington and Sharon L. Hedley.
}
