% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obs_exp.R
\name{obs_exp}
\alias{obs_exp}
\title{Observed versus expected diagnostics for fitted DSMs}
\usage{
obs_exp(model, covar, cut = NULL)
}
\arguments{
\item{model}{a fitted \code{dsm} model object}

\item{covar}{covariate to aggregate by (character)}

\item{cut}{vector of cut points to aggregate at. If not supplied, the unique values of \code{covar} are used.}
}
\value{
\code{data.frame} with values of observed and expected counts.
}
\description{
Given a covariate, calculate the observed and expected counts for each unique value of the covariate. This can be a useful goodness of fit check for DSMs.
}
\details{
One strategy for model checking is to calculate observed and expected counts at different aggregations of the variable. If these match well then the model fit is good.
}
\examples{
library(Distance)
library(dsm)

# example with the Gulf of Mexico dolphin data
data(mexdolphins)
hr.model <- ds(distdata, max(distdata$distance),
               key = "hr", adjustment = NULL)
mod1 <- dsm(count~s(x,y), hr.model, segdata, obsdata)
}
\author{
David L Miller, on the suggestion of Mark Bravington.
}
