% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lidar_search.R
\name{lidar_search}
\alias{lidar_search}
\title{lidar_search}
\usage{
lidar_search(bbox, max_return = 500, preview = FALSE, folder = "")
}
\arguments{
\item{bbox}{vector, a bounding box defining the geographical area
for the LiDAR data search.}

\item{max_return}{numeric, indicating the maximum of returns.}

\item{preview}{logical. If TRUE (default is FALSE), enable or disable
previewing LiDAR graphics.}

\item{folder}{string (optional), indicating an optional folder path
where downloaded LiDAR data files will be saved.}
}
\value{
dataframe
}
\description{
The lidar_search function is designed to facilitate the retrieval
and exploration of LiDAR (Light Detection and Ranging) data within a specified
bounding box (bbox). This function enables users to search for LiDAR data,
preview available graphics, and optionally download LiDAR data files for
further analysis.
}
\note{
The lidar_search function simplifies the process of searching for
and working with LiDAR data via the TNMAccess API: https://tnmaccess.nationalmap.gov/api/v1/docs.
}
\examples{
\donttest{
bbox <- c(-83.742282,42.273389,-83.733442,42.278724)
search_result <- dsmSearch::lidar_search(bbox = bbox,
                                         max_return = 25,
                                         preview = FALSE)
}
}
