% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nzdsr.R
\name{nzdsr}
\alias{nzdsr}
\title{Normalization of a bca mass function}
\usage{
nzdsr(x)
}
\arguments{
\item{x}{A mass function, i.e. a list of class bcaspec..}
}
\value{
The normalized bca mass function.
}
\description{
It may occur that the result of the combination of two mass functions with Dempster's Rule of combination contains a non-zero mass allocated to the empty set. The function \code{nzdsr} normalizes the result of function \code{dsrwon} by dividing the mass value of the non-empty subsets by 1 minus the mass of the empty set.
}
\examples{
x1 <- bca(f=matrix(c(1,0,1,1),nrow=2, byrow = TRUE), 
m=c(0.9,0.1), cnames =c("yes", "no"),
infovarnames = "x", varnb = 1)
x2 <- bca(f=matrix(c(0,1,1,1),nrow=2, byrow = TRUE), 
m=c(0.5,0.5), cnames =c("yes", "no"), 
infovarnames = "x", varnb = 1)
print("combination of x1 and x2")
x1x2 <- dsrwon(x1,x2)
nzdsr(x1x2) 

print("normalization of a bca definition.")
y2 <- bca(f=matrix(c(0,0,0,1,0,0,1,1,1),nrow=3, 
byrow = TRUE), m=c(0.2,0.5,0.3), 
cnames =c("a", "b", "c"), varnb = 1)
nzdsr(y2)  
}
\references{
Shafer, G., (1976). A Mathematical Theory of Evidence. Princeton University Press, Princeton, New Jersey, pp. 57-61: Dempster's rule of combination.
}
\author{
Claude Boivin, Stat.ASSQ
}
