% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlComb.R
\name{mlComb}
\alias{mlComb}
\title{Combine two diagnostic tests with Machine Learning Algorithms.}
\usage{
mlComb(
  markers = NULL,
  status = NULL,
  event = NULL,
  method = NULL,
  resample = NULL,
  niters = 5,
  nfolds = 5,
  nrepeats = 3,
  preProcess = NULL,
  show.plot = TRUE,
  B = 25,
  direction = c("auto", "<", ">"),
  conf.level = 0.95,
  cutoff.method = c("CB", "MCT", "MinValueSp", "MinValueSe", "ValueSp", "ValueSe",
    "MinValueSpSe", "MaxSp", "MaxSe", "MaxSpSe", "MaxProdSpSe", "ROC01", "SpEqualSe",
    "Youden", "MaxEfficiency", "Minimax", "MaxDOR", "MaxKappa", "MinValueNPV",
    "MinValuePPV", "ValueNPV", "ValuePPV", "MinValueNPVPPV", "PROC01", "NPVEqualPPV",
    "MaxNPVPPV", "MaxSumNPVPPV", "MaxProdNPVPPV", "ValueDLR.Negative",
    "ValueDLR.Positive", "MinPvalue", "ObservedPrev", "MeanPrev", "PrevalenceMatching"),
  ...
)
}
\arguments{
\item{markers}{a \code{numeric} data frame that includes two diagnostic tests
results}

\item{status}{a \code{factor} vector that includes the actual disease
status of the patients}

\item{event}{a \code{character} string that indicates the event in the status
to be considered as positive event}

\item{method}{a \code{character} string specifying the method used for
combining the markers. For the available methods see availableMethods()

\bold{IMPORTANT}: See https://topepo.github.io/caret/available-models.html
for further information about the methods used in this function.}

\item{resample}{a \code{character} string that indicates the resampling
method used while training the model. The available methods are "boot",
"boot632", "optimism_boot", "boot_all", "cv", "repeatedcv", "LOOCV", "LGOCV",
"none", "oob", "adaptive_cv", "adaptive_boot" and "adaptive_LGOCV". for
details of these resampling methods see ?caret::trainControl}

\item{niters}{a \code{numeric} value that indicates the number of
bootstrapped resampling iterations (10, default)}

\item{nfolds}{a \code{numeric} value that indicates the number of folds for
cross validation based resampling methods  (5, default)}

\item{nrepeats}{a \code{numeric} value that indicates the number of repeats
for "repeatedcv" option of resampling methods (3, default)}

\item{preProcess}{a \code{character} string that indicates the pre-processing
options to be applied in the data before training the model. Available
pre-processing methods are: "BoxCox", "YeoJohnson", "expoTrans", "center",
"scale", "range", "knnImpute", "bagImpute", "medianImpute", "pca", "ica",
"spatialSign", "corr", "zv", "nzv", and "conditionalX". For detailed
information about the methods see ?caret::preProcess}

\item{show.plot}{a \code{logical} a \code{logical}. If TRUE, a ROC curve is
plotted. Default is TRUE}

\item{B}{a \code{numeric} value that is the number of bootstrap samples for
bagging classifiers, "bagFDA", "bagFDAGCV", "bagEarth" and "bagEarthGCV".
(25, default)}

\item{direction}{a \code{character} string determines in which direction the
comparison will be made.  ">": if the predictor values for the control group
are higher than the values of the case group (controls > cases).
"<": if the predictor values for the control group are lower or equal than
the values of the case group (controls < cases).}

\item{conf.level}{a \code{numeric} value to  determine the confidence interval
for the ROC curve(0.95, default).}

\item{cutoff.method}{a \code{character} string determines the cutoff method
for the ROC curve.}

\item{\dots}{optional arguments passed to selected classifiers.}
}
\value{
A \code{list} of AUC values, diagnostic statistics,
coordinates of the ROC curve for the combination score obtained using
Machine Learning Algorithms as well as the given biomarkers individually, a
comparison table for the AUC values of individual biomarkers and combination
score obtained and the fitted model.
}
\description{
The \code{mlComb} function calculates the combination
scores of two diagnostic tests selected among several Machine Learning
Algorithms
}
\examples{
# call data
data(exampleData1)

# define the function parameters
markers <- exampleData1[, -1]
status <- factor(exampleData1$group, levels = c("not_needed", "needed"))
event <- "needed"

model <- mlComb(
  markers = markers, status = status, event = event,
  method = "knn", resample = "repeatedcv", nfolds = 10, nrepeats = 5,
  preProcess = c("center", "scale"), direction = "<", cutoff.method = "Youden"
)

}
\author{
Serra Ilayda Yerlitas, Serra Bersan Gengec, Necla Kochan,
Gozde Erturk Zararsiz, Selcuk Korkmaz, Gokmen Zararsiz
}
