% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtrackr.R
\name{p_slice}
\alias{p_slice}
\title{Slice operations}
\usage{
p_slice(
  .data,
  ...,
  .messages = c("{.count.in} before", "{.count.out} after"),
  .headline = "slice data"
)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{...}{
  Arguments passed on to \code{\link[dplyr:slice]{dplyr::slice}}
  \describe{
    \item{\code{.preserve}}{Relevant when the \code{.data} input is grouped.
If \code{.preserve = FALSE} (the default), the grouping structure
is recalculated based on the resulting data, otherwise the grouping is kept as is.}
  }}

\item{.messages}{a set of glue specs. The glue code can use any global
variable, \{.count.in\}, \{.count.out\} for the input and output dataframes
sizes respectively and \{.excluded\} for the difference}

\item{.headline}{a glue spec. The glue code can use any global variable,
\{.count.in\}, \{.count.out\} for the input and output dataframes sizes
respectively.}
}
\value{
the sliced dataframe with the history graph updated.
}
\description{
Slice operations behave as in dplyr, except the history graph can be updated with
tracked dataframe with the before and after sizes of the dataframe.
See \code{\link[dplyr:slice]{dplyr::slice()}}, \code{\link[dplyr:slice]{dplyr::slice_head()}}, \code{\link[dplyr:slice]{dplyr::slice_tail()}},
\code{\link[dplyr:slice]{dplyr::slice_min()}}, \code{\link[dplyr:slice]{dplyr::slice_max()}}, \code{\link[dplyr:slice]{dplyr::slice_sample()}},
for more details on the underlying functions.
}
\examples{
library(dplyr)
library(dtrackr)

# an arbitrary 50 items from the iris dataframe is selected. The
# history is tracked
iris \%>\% track() \%>\% slice(51:100) \%>\% history()

}
\seealso{
dplyr::slice()
}
