% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R, R/set.R, R/year.R
\name{dtt_years}
\alias{dtt_years}
\alias{dtt_years<-}
\alias{dtt_set_year}
\alias{dtt_year}
\alias{dtt_year<-}
\alias{dtt_year.Date}
\alias{dtt_year.POSIXct}
\alias{dtt_year<-.Date}
\alias{dtt_year<-.POSIXct}
\title{Get and Set Year Values}
\usage{
dtt_years(x, ...)

dtt_years(x) <- value

dtt_set_year(x, value)

dtt_year(x, ...)

dtt_year(x) <- value

\method{dtt_year}{Date}(x, ...)

\method{dtt_year}{POSIXct}(x, ...)

\method{dtt_year}{Date}(x) <- value

\method{dtt_year}{POSIXct}(x) <- value
}
\arguments{
\item{x}{A date/time vector.}

\item{...}{Unused.}

\item{value}{A integer vector of the year value(s).}
}
\value{
An integer vector (or the modified date/time vector).
}
\description{
Gets and sets year values for date/time vectors.
}
\section{Methods (by class)}{
\itemize{
\item \code{Date}: Get integer vector of year values for a Date vector

\item \code{POSIXct}: Get integer vector of year values for a POSIXct vector

\item \code{Date}: Set year values for a Date vector

\item \code{POSIXct}: Set year values for a POSIXct vector
}}

\examples{
x <- as.Date("1990-01-02")
dtt_year(x)
dtt_year(x) <- 11L
x

x <- as.POSIXct("1990-01-02 23:40:51")
dtt_year(x)
dtt_year(x) <- 2022L
x
}
