% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-twdtwRaster.R, R/methods.R
\docType{methods}
\name{twdtwRaster-class}
\alias{[,twdtwRaster,ANY,ANY,ANY-method}
\alias{[[,twdtwRaster,ANY,ANY-method}
\alias{bands}
\alias{bands,twdtwRaster-method}
\alias{coverages}
\alias{coverages,twdtwRaster-method}
\alias{crop,twdtwRaster-method}
\alias{dim,twdtwRaster-method}
\alias{extent,twdtwRaster-method}
\alias{index,twdtwRaster-method}
\alias{is.twdtwRaster}
\alias{is.twdtwRaster,ANY-method}
\alias{labels,twdtwRaster-method}
\alias{layers}
\alias{layers,twdtwRaster-method}
\alias{length,twdtwRaster-method}
\alias{levels,twdtwRaster-method}
\alias{names,twdtwRaster-method}
\alias{ncol,twdtwRaster-method}
\alias{nlayers,twdtwRaster-method}
\alias{nrow,twdtwRaster-method}
\alias{projection,twdtwRaster-method}
\alias{res,twdtwRaster-method}
\alias{show,twdtwRaster-method}
\alias{twdtwRaster}
\alias{twdtwRaster,ANY-method}
\alias{twdtwRaster-class}
\title{class "twdtwRaster"}
\usage{
\S4method{twdtwRaster}{ANY}(..., timeline, doy = NULL, layers = NULL,
  labels = NULL, levels = NULL, filepath = NULL)

\S4method{dim}{twdtwRaster}(x)

\S4method{res}{twdtwRaster}(x)

\S4method{extent}{twdtwRaster}(x, y, ...)

\S4method{projection}{twdtwRaster}(x)

\S4method{ncol}{twdtwRaster}(x)

\S4method{nrow}{twdtwRaster}(x)

\S4method{nlayers}{twdtwRaster}(x)

\S4method{levels}{twdtwRaster}(x)

\S4method{layers}{twdtwRaster}(x)

\S4method{coverages}{twdtwRaster}(x)

\S4method{bands}{twdtwRaster}(x)

\S4method{names}{twdtwRaster}(x)

\S4method{index}{twdtwRaster}(x)

\S4method{length}{twdtwRaster}(x)

\S4method{[}{twdtwRaster,ANY,ANY,ANY}(x, i)

\S4method{[[}{twdtwRaster,ANY,ANY}(x, i)

\S4method{labels}{twdtwRaster}(object)

\S4method{crop}{twdtwRaster}(x, y, ...)

\S4method{extent}{twdtwRaster}(x, y, ...)

\S4method{show}{twdtwRaster}(object)

\S4method{is.twdtwRaster}{ANY}(x)
}
\arguments{
\item{...}{objects of class \code{\link[raster]{RasterBrick-class}} or 
\code{\link[raster]{RasterStack-class}}.}

\item{timeline}{a vector with the dates of the satellite images 
in the format of "YYYY-MM-DD".}

\item{doy}{A \code{\link[raster]{RasterBrick-class}} or 
\code{\link[raster]{RasterStack-class}} with a sequence of days of the year for each pixel. 
\code{doy} must have the same spatial and temporal extents as the Raster* objects passed to \code{...}.
If \code{doy} is not informed then at least one Raster* object must be passed through \code{...}.}

\item{layers}{a vector with the names of the \code{Raster*} objects 
passed to "\code{...}". If not informed the layers are set to the 
names of objects in "\code{...}".}

\item{labels}{a vector of class \code{\link[base]{character}} with 
labels of the values in the Raster* objects. This is 
useful for categorical Raster* values of land use classes.}

\item{levels}{a vector of class \code{\link[base]{numeric}} with 
levels of the values in the Raster* objects. This is 
useful for categorical Raster* values of land use classes.}

\item{filepath}{A character. The path to save the raster time series. If informed the 
function saves a raster file for each Raster* object in the list, \emph{i.e} one file 
for each time series. This way the function retrieves an list of 
\code{\link[raster]{RasterBrick-class}}. It is useful when the time series are 
originally stores in separated files. See details.}

\item{x}{an object of class twdtwRaster.}

\item{y}{Extent object, or any object from which an Extent object can be extracted.}

\item{i}{indices of the time series.}

\item{object}{an object of class twdtwRaster.}
}
\description{
Class for set of satellite time series.
}
\details{
The performance the functions \code{\link[dtwSat]{twdtwApply}} and 
\code{\link[dtwSat]{getTimeSeries}} is improved if the Raster* objects are connected 
to files with the whole time series for each attribute.
}
\section{Methods (by generic)}{
\itemize{
\item \code{twdtwRaster}: Create object of class twdtwRaster.

\item \code{is.twdtwRaster}: Check if the object belongs to the class twdtwRaster.
}}
\section{Slots }{

\describe{
 \item{\code{timeseries}:}{A list of multi-layers Raster* objects 
       with the satellite image time series.}
 \item{\code{timeline}:}{A vector of class \code{\link[base]{date}} 
       with dates of the satellite images in \code{timeseries}.}
 \item{\code{layers}:}{A vector of class \code{\link[base]{character}} 
       with the names of the Raster* objects.}
 \item{\code{labels}:}{A vector of class \code{\link[base]{factor}} 
       with levels and labels of the values in the Raster* objects. This 
       is useful for categorical Raster* values of land use classes.}
}
}
\examples{
# Creating new object of class twdtwTimeSeries 
evi = brick(system.file("lucc_MT/data/evi.tif", package="dtwSat"))
timeline = scan(system.file("lucc_MT/data/timeline", package="dtwSat"), what="date")
rts = new("twdtwRaster", timeseries = evi, timeline = timeline)

\dontrun{
# Creating objects of class twdtwRaster 
evi = brick(system.file("lucc_MT/data/evi.tif", package="dtwSat"))
timeline = scan(system.file("lucc_MT/data/timeline", package="dtwSat"), what="date")
ts_evi = twdtwRaster(evi, timeline=timeline)

ndvi = brick(system.file("lucc_MT/data/ndvi.tif", package="dtwSat"))
blue = brick(system.file("lucc_MT/data/blue.tif", package="dtwSat"))
red = brick(system.file("lucc_MT/data/red.tif", package="dtwSat"))
nir = brick(system.file("lucc_MT/data/nir.tif", package="dtwSat"))
mir = brick(system.file("lucc_MT/data/mir.tif", package="dtwSat"))
doy = brick(system.file("lucc_MT/data/doy.tif", package="dtwSat"))
rts = twdtwRaster(evi, ndvi, blue, red, nir, mir, timeline=timeline, doy=doy)
}
}
\author{
Victor Maus, \email{vwmaus1@gmail.com}
}
\seealso{
\code{\link[dtwSat]{twdtwApply}}, 
\code{\link[dtwSat]{getTimeSeries}},
\code{\link[dtwSat]{twdtwMatches-class}}, and 
\code{\link[dtwSat]{twdtwTimeSeries-class}}
}

