% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg.R
\docType{package}
\name{dtwclust-package}
\alias{dtwclust-package}
\title{Time series clustering along with optimizations for the Dynamic Time Warping distance}
\description{
Time series clustering with a wide variety of strategies and a series of optimizations specific
to the Dynamic Time Warping (DTW) distance and its corresponding lower bounds (LBs).
}
\details{
Many of the algorithms implemented in this package are specifically tailored to DTW, hence its
name. However, the main clustering function is flexible so that one can test many different
clustering approaches, using either the time series directly, or by applying suitable
transformations and then clustering in the resulting space. Other implementations included in the
package provide some alternatives to DTW.

DTW is a dynamic programming algorithm that tries to find the optimum warping path between two
series. Over the years, several variations have appeared in order to make the procedure faster or
more efficient. Please refer to the included references for more information, especially Giorgino
(2009), which is a good practical introduction.

Most optimizations require equal dimensionality, which means time series should have equal
length. DTW itself does not require this, but it is relatively expensive to compute. Other
distance definitions may be used, or series could be reinterpolated to a matching length
(Ratanamahatana and Keogh 2004).

The main clustering function and entry point for this package is \code{\link[=tsclust]{tsclust()}}, with a convenience
wrapper for multiple tests in \code{\link[=compare_clusterings]{compare_clusterings()}}, and a shiny app in
\code{\link[=interactive_clustering]{interactive_clustering()}}. There is another less-general-purpose shiny app in \code{\link[=ssdtwclust]{ssdtwclust()}}.

Please note the random number generator is set to L'Ecuyer-CMRG when \pkg{dtwclust} is attached
in an attempt to preserve reproducibility. You are free to change this afterwards if you wish
(see \code{\link[base:RNGkind]{base::RNGkind()}}), but \pkg{dtwclust} will always use L'Ecuyer-CMRG internally.

For more information, please read the included package vignettes, which can be accessed by typing
\code{browseVignettes("dtwclust")}.
}
\note{
This software package was developed independently of any organization or institution that is or
has been associated with the author.

This package can be used without attaching it with \code{\link[base:library]{base::library()}} with some caveats:
\itemize{
\item The \pkg{methods} \link[methods:methods-package]{package} must be attached. \code{R} usually does this
automatically, but \code{\link[utils:Rscript]{utils::Rscript()}} does not.
\item If you want to use the \pkg{proxy} version of \code{\link[dtw:dtw]{dtw::dtw()}} (e.g. for clustering), you have to
attach the \pkg{dtw} package manually.
}

Be careful with reproducibility, \code{R}'s random number generator is only changed session-wide if
\pkg{dtwclust} is attached.
}
\references{
Please refer to the package's vignette's references.
}
\seealso{
\code{\link[=tsclust]{tsclust()}}, \code{\link[=compare_clusterings]{compare_clusterings()}}, \code{\link[=interactive_clustering]{interactive_clustering()}}, \code{\link[=ssdtwclust]{ssdtwclust()}}, \code{\link[=dtw_basic]{dtw_basic()}},
\code{\link[proxy:dist]{proxy::dist()}}.
}
\author{
Alexis Sarda-Espinosa
}
