% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Connection.R,
%   R/dbAppendTable__duckdb_connection.R, R/dbBegin__duckdb_connection.R,
%   R/dbCommit__duckdb_connection.R, R/dbDataType__duckdb_connection.R,
%   R/dbExistsTable__duckdb_connection_ANY.R,
%   R/dbGetInfo__duckdb_connection.R, R/dbIsValid__duckdb_connection.R,
%   R/dbListFields__duckdb_connection_character.R,
%   R/dbListTables__duckdb_connection.R,
%   R/dbQuoteIdentifier__duckdb_connection.R,
%   R/dbQuoteLiteral__duckdb_connection.R,
%   R/dbRemoveTable__duckdb_connection_character.R,
%   R/dbRollback__duckdb_connection.R,
%   R/dbSendQuery__duckdb_connection_character.R,
%   R/dbWriteTable__duckdb_connection_character_data.frame.R,
%   R/show__duckdb_connection.R
\docType{class}
\name{duckdb_connection-class}
\alias{duckdb_connection-class}
\alias{duckdb_connection}
\alias{dbAppendTable__duckdb_connection}
\alias{dbAppendTable,duckdb_connection-method}
\alias{dbBegin__duckdb_connection}
\alias{dbBegin,duckdb_connection-method}
\alias{dbCommit__duckdb_connection}
\alias{dbCommit,duckdb_connection-method}
\alias{dbDataType__duckdb_connection}
\alias{dbDataType,duckdb_connection-method}
\alias{dbExistsTable__duckdb_connection_ANY}
\alias{dbExistsTable,duckdb_connection,ANY-method}
\alias{dbGetInfo__duckdb_connection}
\alias{dbGetInfo,duckdb_connection-method}
\alias{dbIsValid__duckdb_connection}
\alias{dbIsValid,duckdb_connection-method}
\alias{dbListFields__duckdb_connection_character}
\alias{dbListFields,duckdb_connection,character-method}
\alias{dbListTables__duckdb_connection}
\alias{dbListTables,duckdb_connection-method}
\alias{dbQuoteIdentifier,duckdb_connection,ANY-method}
\alias{dbQuoteIdentifier,duckdb_connection,character-method}
\alias{dbQuoteIdentifier,duckdb_connection,SQL-method}
\alias{dbQuoteIdentifier,duckdb_connection,Id-method}
\alias{dbQuoteLiteral__duckdb_connection}
\alias{dbQuoteLiteral,duckdb_connection-method}
\alias{dbRemoveTable__duckdb_connection_character}
\alias{dbRemoveTable,duckdb_connection,character-method}
\alias{dbRollback__duckdb_connection}
\alias{dbRollback,duckdb_connection-method}
\alias{dbSendQuery__duckdb_connection_character}
\alias{dbSendQuery,duckdb_connection,character-method}
\alias{dbWriteTable__duckdb_connection_character_data.frame}
\alias{dbWriteTable,duckdb_connection,character,data.frame-method}
\alias{show__duckdb_connection}
\alias{show,duckdb_connection-method}
\title{DuckDB connection class}
\usage{
\S4method{dbAppendTable}{duckdb_connection}(conn, name, value, ..., row.names = NULL)

\S4method{dbBegin}{duckdb_connection}(conn, ...)

\S4method{dbCommit}{duckdb_connection}(conn, ...)

\S4method{dbDataType}{duckdb_connection}(dbObj, obj, ...)

\S4method{dbExistsTable}{duckdb_connection,ANY}(conn, name, ...)

\S4method{dbGetInfo}{duckdb_connection}(dbObj, ...)

\S4method{dbIsValid}{duckdb_connection}(dbObj, ...)

\S4method{dbListFields}{duckdb_connection,character}(conn, name, ...)

\S4method{dbListTables}{duckdb_connection}(conn, ...)

\S4method{dbQuoteIdentifier}{duckdb_connection,ANY}(conn, x, ...)

\S4method{dbQuoteLiteral}{duckdb_connection}(conn, x, ...)

\S4method{dbRemoveTable}{duckdb_connection,character}(conn, name, ..., fail_if_missing = TRUE)

\S4method{dbRollback}{duckdb_connection}(conn, ...)

\S4method{dbSendQuery}{duckdb_connection,character}(conn, statement, params = NULL, ..., arrow = FALSE)

\S4method{dbWriteTable}{duckdb_connection,character,data.frame}(
  conn,
  name,
  value,
  ...,
  row.names = FALSE,
  overwrite = FALSE,
  append = FALSE,
  field.types = NULL,
  temporary = FALSE
)

\S4method{show}{duckdb_connection}(object)
}
\arguments{
\item{conn}{A \linkS4class{duckdb_connection} object as returned by \code{\link[DBI:dbConnect]{DBI::dbConnect()}}}

\item{name}{The table name, passed on to \code{\link[DBI:dbQuoteIdentifier]{dbQuoteIdentifier()}}. Options are:
\itemize{
\item a character string with the unquoted DBMS table name,
e.g. \code{"table_name"},
\item a call to \code{\link[DBI:Id]{Id()}} with components to the fully qualified table name,
e.g. \code{Id(schema = "my_schema", table = "table_name")}
\item a call to \code{\link[DBI:SQL]{SQL()}} with the quoted and fully qualified table name
given verbatim, e.g. \code{SQL('"my_schema"."table_name"')}
}}

\item{value}{A \link{data.frame} (or coercible to data.frame).}

\item{...}{Other parameters passed on to methods.}

\item{row.names}{Whether the row.names of the data.frame should be preserved}

\item{dbObj}{An object inheriting from class \linkS4class{duckdb_connection}.}

\item{obj}{An R object whose SQL type we want to determine.}

\item{statement}{a character string containing SQL.}

\item{params}{For \code{dbBind()}, a list of values, named or unnamed,
or a data frame, with one element/column per query parameter.
For \code{dbBindArrow()}, values as a nanoarrow stream,
with one column per query parameter.}

\item{arrow}{Whether the query should be returned as an Arrow Table}

\item{overwrite}{If a table with the given name already exists, should it be overwritten?}

\item{append}{If a table with the given name already exists, just try to append the passed data to it}

\item{field.types}{Override the auto-generated SQL types}

\item{temporary}{Should the created table be temporary?}

\item{object}{Any R object}
}
\description{
Implements \link[DBI:DBIConnection-class]{DBI::DBIConnection}.
}
\keyword{internal}
