# Generated by 02-duckplyr_df-methods.R
#' @export
transmute.duckplyr_df <- function(.data, ...) {
  force(.data)

  dots <- check_transmute_args(...)
  dots <- dplyr_quosures(!!!dots)
  dots <- fix_auto_name(dots)

  rel_try(
    "Can't use relational with zero-column result set." = (length(dots) == 0),
    {
      exprs <- rel_translate_dots(dots, .data)
      rel <- duckdb_rel_from_df(.data)
      out_rel <- rel_project(rel, exprs)
      out <- rel_to_df(out_rel)
      out <- dplyr_reconstruct_dispatch(out, .data)
      return(out)
    }
  )

  # dplyr forward
  transmute <- dplyr$transmute.data.frame
  out <- transmute(.data, ...)
  return(out)

  # dplyr implementation
  dots <- check_transmute_args(...)
  dots <- dplyr_quosures(!!!dots)

  # We don't expose `.by` because `transmute()` is superseded
  by <- compute_by(by = NULL, data = .data)

  cols <- mutate_cols(.data, dots, by)

  out <- dplyr_col_modify(.data, cols)

  # Compact out `NULL` columns that got removed.
  # These won't exist in `out`, but we don't want them to look "new".
  # Note that `dplyr_col_modify()` makes it impossible to `NULL` a group column,
  # which we rely on below.
  cols <- compact_null(cols)

  # Retain expression columns in order of their appearance
  cols_expr <- names(cols)

  # Retain untouched group variables up front
  cols_group <- by$names
  cols_group <- setdiff(cols_group, cols_expr)

  cols_retain <- c(cols_group, cols_expr)

  dplyr_col_select(out, cols_retain)
}

duckplyr_transmute <- function(.data, ...) {
  try_fetch(
    .data <- as_duckplyr_df(.data),
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- transmute(.data, ...)
  class(out) <- setdiff(class(out), "duckplyr_df")
  out
}
