# Generated by 02-duckplyr_df-methods.R
#' @export
group_map.duckplyr_df <- function(.data, .f, ..., .keep = FALSE, keep = deprecated()) {
  if (!missing(keep)) {
    lifecycle::deprecate_warn("1.0.0", "group_map(keep = )", "group_map(.keep = )", always = TRUE)
    .keep <- keep
  }

  # Our implementation
  rel_try(
    # Always fall back to dplyr
    "No relational implementation for group_map()" = TRUE,
    {
      return(out)
    }
  )

  # dplyr forward
  group_map <- dplyr$group_map.data.frame
  out <- group_map(.data, .f, ..., .keep = .keep)
  return(out)

  # dplyr implementation
  if (!missing(keep)) {
    lifecycle::deprecate_warn("1.0.0", "group_map(keep = )", "group_map(.keep = )", always = TRUE)
    .keep <- keep
  }
  .f <- as_group_map_function(.f)

  # call the function on each group
  chunks <- if (is_grouped_df(.data)) {
    group_split(.data, .keep = isTRUE(.keep))
  } else {
    group_split(.data)
  }
  keys  <- group_keys(.data)
  group_keys <- map(seq_len(nrow(keys)), function(i) keys[i, , drop = FALSE])

  if (length(chunks)) {
    map2(chunks, group_keys, .f, ...)
  } else {
    # calling .f with .x and .y set to prototypes
    structure(list(), ptype = .f(attr(chunks, "ptype"), keys[integer(0L), ], ...))
  }
}

duckplyr_group_map <- function(.data, ...) {
  try_fetch(
    .data <- as_duckplyr_df(.data),
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- group_map(.data, ...)
  class(out) <- setdiff(class(out), "duckplyr_df")
  out
}
