% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_file.R
\name{compute_file}
\alias{compute_file}
\alias{compute_parquet}
\alias{compute_csv}
\title{Compute results to a file}
\usage{
compute_parquet(x, path, ..., prudence = NULL, options = NULL)

compute_csv(x, path, ..., prudence = NULL, options = NULL)
}
\arguments{
\item{x}{A duckplyr frame.}

\item{path}{The path to store the result in.}

\item{...}{These dots are for future extensions and must be empty.}

\item{prudence}{Memory protection, controls if DuckDB may convert
intermediate results in DuckDB-managed memory to data frames in R memory.
\itemize{
\item \code{"lavish"}: regardless of size,
\item \code{"stingy"}: never,
\item \code{"thrifty"}: up to a maximum size of 1 million cells.
}

The default is to inherit from the input.
This argument is provided here only for convenience.
The same effect can be achieved by forwarding the output to \code{\link[=as_duckdb_tibble]{as_duckdb_tibble()}}
with the desired prudence.
See \code{vignette("prudence")} for more information.}

\item{options}{A list of additional options to pass to create the storage format,
see \url{https://duckdb.org/docs/data/parquet/overview#writing-to-parquet-files}
or \url{https://duckdb.org/docs/data/csv/overview#writing-using-the-copy-statement}
for details.}
}
\value{
A duckplyr frame.
}
\description{
These functions apply to duckplyr frames.
They executes a query and stores the results in a flat file.
The result is a duckplyr frame that can be used with subsequent dplyr verbs.

\code{compute_parquet()} creates a Parquet file.

\code{compute_csv()} creates a CSV file.
}
\examples{
library(duckplyr)
df <- data.frame(x = c(1, 2))
df <- mutate(df, y = 2)
path <- tempfile(fileext = ".parquet")
df <- compute_parquet(df, path)
explain(df)
}
\seealso{
\code{\link[=compute.duckplyr_df]{compute.duckplyr_df()}}, \code{\link[dplyr:compute]{dplyr::collect()}}
}
