% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz-methods.R
\name{methods_overwrite}
\alias{methods_overwrite}
\alias{methods_restore}
\title{Forward all dplyr methods to duckplyr}
\usage{
methods_overwrite()

methods_restore()
}
\value{
Called for their side effects.
}
\description{
After calling \code{methods_overwrite()}, all dplyr methods are redirected to duckplyr
for the duraton of the session, or until a call to \code{methods_restore()}.
The \code{methods_overwrite()} function is called automatically when the package is loaded
if the environment variable \code{DUCKPLYR_METHODS_OVERWRITE} is set to \code{TRUE}.
}
\examples{
tibble(a = 1:3) \%>\%
  mutate(b = a + 1)

methods_overwrite()

tibble(a = 1:3) \%>\%
  mutate(b = a + 1)

methods_restore()

tibble(a = 1:3) \%>\%
  mutate(b = a + 1)
}
